#!/bin/bash
# ------------------------------------------------------------------------------
#	Shell script file
#
#  	Copyright(©)   PerkinElmer Cellular Technologies Germany GmbH 2021
#
#  	Description: Create virtual environment on target system
#
#		Examples:	Install.sh
#					
#		Remark: Version 1.0.0.22077
#
# 		Last change: 
#
#
#    $Date: 2020-06-03 $         $Revision: $
#
# ------------------------------------------------------------------------------
HomeDir=/home/operator
sudo systemctl is-active pyrunner.service && sudo systemctl stop pyrunner.service
sudo systemctl is-active django.service && sudo systemctl stop django.service
sudo systemctl is-active chownwdog.service && sudo systemctl stop chownwdog.service
sudo systemctl disable pyrunner.service
sudo systemctl disable django.service
sudo systemctl disable chownwdog.service
#sudo killall -w -r python*   to avoid killing kira UI processes
echo Save PyRunner configuration...
zip $HomeDir/temp/PyRunner-$(date +%Y-%m-%d-%H%M%S).zip $HomeDir/pyrunner/lib/python3.11/site-packages/PyRunner/config/* $HomeDir/.config/pyrunner/*
echo remove pyrunner virtual environment
sudo rm -r $HomeDir/pyrunner
echo remove Installation packages...
rm -r $HomeDir/.PyRInstall
rm $HomeDir/install.sh
rm $HomeDir/installsystemd.sh
rm $HomeDir/StartPyRunner.sh
rm $HomeDir/StopPyRunner.sh
rm $HomeDir/RestartPyRunner.sh
rm $HomeDir/chkwho.sh
sudo rm /etc/profile.d/chkwho.sh
sudo rm /etc/systemd/system/pyrunner.service
sudo rm /etc/systemd/system/django.service
sudo rm /etc/systemd/system/chownwdog.service
sudo systemctl daemon-reload
echo PyRunner removed!
